/*
 * Decompiled with CFR 0.152.
 */
package net.ftb.gui.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import net.ftb.data.Settings;
import net.ftb.download.Locations;
import net.ftb.gui.LaunchFrame;
import net.ftb.locale.I18N;
import net.ftb.log.Logger;
import net.ftb.util.SwingUtils;

public class AdvancedOptionsDialog
extends JDialog {
    private JButton exit;
    private JLabel downloadLocationLbl;
    private static JComboBox downloadLocation;
    private JLabel javaPathLbl;
    private JTextField javaPath;
    private JLabel additionalJavaOptionsLbl;
    private JTextField additionalJavaOptions;
    private JLabel mcWindowSizeLbl;
    private JTextField mcWindowSizeWidth;
    private JLabel mcWindowSizeSepLbl;
    private JTextField mcWindowSizeHeight;
    private JLabel mcWindowPosLbl;
    private JTextField mcWindowPosX;
    private JLabel mcWindowPosSepLbl;
    private JTextField mcWindowPosY;
    private JCheckBox autoMaxCheck;
    private JCheckBox snooper;
    private JCheckBox debugLauncherVerbose;
    private JCheckBox betaChannel;
    private final Settings settings = Settings.getSettings();

    public AdvancedOptionsDialog() {
        super((Frame)LaunchFrame.getInstance(), true);
        this.setupGui();
        if (Locations.serversLoaded && Locations.downloadServers.containsKey(this.settings.getDownloadServer())) {
            downloadLocation.setSelectedItem(this.settings.getDownloadServer());
        }
        this.mcWindowSizeWidth.setText(Integer.toString(this.settings.getLastDimension().width));
        this.mcWindowSizeHeight.setText(Integer.toString(this.settings.getLastDimension().height));
        this.mcWindowPosX.setText(Integer.toString(this.settings.getLastPosition().x));
        this.mcWindowPosY.setText(Integer.toString(this.settings.getLastPosition().y));
        this.autoMaxCheck.setSelected((this.settings.getLastExtendedState() & 6) == 6);
        this.snooper.setSelected(this.settings.getSnooper());
        this.debugLauncherVerbose.setSelected(this.settings.getDebugLauncher());
        this.betaChannel.setSelected(this.settings.isBetaChannel());
        FocusAdapter settingsChangeListener = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                AdvancedOptionsDialog.this.saveSettingsInto(AdvancedOptionsDialog.this.settings);
            }
        };
        downloadLocation.addFocusListener(settingsChangeListener);
        this.javaPath.addFocusListener(settingsChangeListener);
        this.additionalJavaOptions.addFocusListener(settingsChangeListener);
        this.mcWindowSizeWidth.addFocusListener(settingsChangeListener);
        this.mcWindowSizeHeight.addFocusListener(settingsChangeListener);
        this.mcWindowPosX.addFocusListener(settingsChangeListener);
        this.mcWindowPosY.addFocusListener(settingsChangeListener);
        this.autoMaxCheck.addFocusListener(settingsChangeListener);
        this.snooper.addFocusListener(settingsChangeListener);
        this.debugLauncherVerbose.addFocusListener(settingsChangeListener);
        this.betaChannel.addFocusListener(settingsChangeListener);
        this.exit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdvancedOptionsDialog.this.setVisible(false);
            }
        });
    }

    public static void setDownloadServers() {
        String downloadserver = Settings.getSettings().getDownloadServer();
        downloadLocation.removeAllItems();
        for (String server : Locations.downloadServers.keySet()) {
            downloadLocation.addItem(server);
        }
        if (Locations.downloadServers.containsKey(downloadserver)) {
            downloadLocation.setSelectedItem(downloadserver);
        }
    }

    public String[] getDownloadServerNames() {
        if (!Locations.serversLoaded) {
            Logger.logWarn("Servers not loaded yet.");
            return new String[]{"Automatic"};
        }
        String[] out = new String[Locations.downloadServers.size()];
        for (int i = 0; i < out.length; ++i) {
            out[i] = String.valueOf(Locations.downloadServers.keySet().toArray()[i]);
        }
        return out;
    }

    public void saveSettingsInto(Settings settings) {
        settings.setDownloadServer(String.valueOf(downloadLocation.getItemAt(downloadLocation.getSelectedIndex())));
        settings.setLastDimension(new Dimension(Integer.parseInt(this.mcWindowSizeWidth.getText()), Integer.parseInt(this.mcWindowSizeHeight.getText())));
        int lastExtendedState = settings.getLastExtendedState();
        settings.setLastExtendedState(this.autoMaxCheck.isSelected() ? lastExtendedState | 6 : lastExtendedState & 0xFFFFFFF9);
        settings.setLastPosition(new Point(Integer.parseInt(this.mcWindowPosX.getText()), Integer.parseInt(this.mcWindowPosY.getText())));
        settings.setJavaPath(this.javaPath.getText());
        settings.setAdditionalJavaOptions(this.additionalJavaOptions.getText());
        settings.setSnooper(this.snooper.isSelected());
        settings.setDebugLauncher(this.debugLauncherVerbose.isSelected());
        settings.setBetaChannel(this.betaChannel.isSelected());
        settings.save();
        Settings.setCurrentJava(null);
        LaunchFrame.getInstance().optionsPane.updateJavaLabels();
    }

    private void setupGui() {
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/image/logo_ftb.png")));
        this.setTitle(I18N.getLocaleString("ADVANCED_OPTIONS_TITLE"));
        this.setResizable(true);
        Container panel = this.getContentPane();
        SpringLayout layout = new SpringLayout();
        this.getContentPane().setLayout(layout);
        this.downloadLocationLbl = new JLabel(I18N.getLocaleString("ADVANCED_OPTIONS_DLLOCATION"));
        downloadLocation = new JComboBox<String>(this.getDownloadServerNames());
        this.javaPathLbl = new JLabel(I18N.getLocaleString("ADVANCED_OPTIONS_JAVA_PATH"));
        this.javaPath = new JTextField();
        String javapath = this.settings.getJavaPath();
        if (javapath != null) {
            this.javaPath.setText(javapath);
            if (!new File(javapath).isFile()) {
                this.javaPath.setBackground(Color.RED);
            }
        } else {
            this.javaPath.setBackground(Color.RED);
        }
        this.javaPath.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (!AdvancedOptionsDialog.this.javaPath.getText().equals("") && !new File(AdvancedOptionsDialog.this.javaPath.getText()).isFile()) {
                    AdvancedOptionsDialog.this.javaPath.setBackground(Color.RED);
                } else {
                    AdvancedOptionsDialog.this.javaPath.setBackground(new Color(40, 40, 40));
                }
            }
        });
        this.additionalJavaOptionsLbl = new JLabel(I18N.getLocaleString("ADVANCED_OPTIONS_ADDJAVAOPTIONS"));
        this.additionalJavaOptions = new JTextField(this.settings.getAdditionalJavaOptions());
        this.mcWindowSizeLbl = new JLabel(I18N.getLocaleString("ADVANCED_OPTIONS_MCWINDOW_SIZE"));
        this.mcWindowSizeWidth = new JTextField(4);
        this.mcWindowSizeSepLbl = new JLabel("x");
        this.mcWindowSizeHeight = new JTextField(4);
        this.mcWindowPosLbl = new JLabel(I18N.getLocaleString("ADVANCED_OPTIONS_MCWINDOW_POS"));
        this.mcWindowPosX = new JTextField(4);
        this.mcWindowPosSepLbl = new JLabel("x");
        this.mcWindowPosY = new JTextField(4);
        this.autoMaxCheck = new JCheckBox(I18N.getLocaleString("ADVANCED_OPTIONS_MCWINDOW_AUTOMAXCHECK"));
        this.snooper = new JCheckBox(I18N.getLocaleString("ADVANCED_OPTIONS_DISABLEGOOGLEANALYTICS"));
        this.debugLauncherVerbose = new JCheckBox(I18N.getLocaleString("ADVANCED_OPTIONS_DEBUGLAUNCHERVERBOSE"));
        this.betaChannel = new JCheckBox(I18N.getLocaleString("ADVANCED_OPTIONS_BETA"));
        this.exit = new JButton(I18N.getLocaleString("MAIN_EXIT"));
        this.downloadLocationLbl.setLabelFor(downloadLocation);
        this.add(this.downloadLocationLbl);
        this.add(downloadLocation);
        this.add(this.javaPathLbl);
        this.add(this.javaPath);
        this.add(this.additionalJavaOptionsLbl);
        this.add(this.additionalJavaOptions);
        this.add(this.mcWindowSizeLbl);
        this.add(this.mcWindowSizeWidth);
        this.add(this.mcWindowSizeSepLbl);
        this.add(this.mcWindowSizeHeight);
        this.add(this.mcWindowPosLbl);
        this.add(this.mcWindowPosX);
        this.add(this.mcWindowPosSepLbl);
        this.add(this.mcWindowPosY);
        this.add(this.autoMaxCheck);
        this.add(this.snooper);
        this.add(this.debugLauncherVerbose);
        this.add(this.betaChannel);
        this.add(this.exit);
        Spring hSpring = Spring.constant(10);
        layout.putConstraint("West", (Component)this.downloadLocationLbl, hSpring, "West", (Component)panel);
        layout.putConstraint("West", (Component)this.javaPathLbl, hSpring, "West", (Component)panel);
        layout.putConstraint("West", (Component)this.additionalJavaOptionsLbl, hSpring, "West", (Component)panel);
        layout.putConstraint("West", (Component)this.mcWindowSizeLbl, hSpring, "West", (Component)panel);
        layout.putConstraint("West", (Component)this.mcWindowPosLbl, hSpring, "West", (Component)panel);
        layout.putConstraint("West", (Component)this.autoMaxCheck, hSpring, "West", (Component)panel);
        layout.putConstraint("West", (Component)this.snooper, hSpring, "West", (Component)panel);
        layout.putConstraint("West", (Component)this.debugLauncherVerbose, hSpring, "West", (Component)panel);
        layout.putConstraint("West", (Component)this.betaChannel, hSpring, "West", (Component)panel);
        Spring columnWidth = SwingUtils.springMax(Spring.width(this.downloadLocationLbl), Spring.width(this.javaPathLbl), Spring.width(this.additionalJavaOptionsLbl), Spring.width(this.mcWindowSizeLbl), Spring.width(this.mcWindowPosLbl));
        hSpring = SwingUtils.springSum(hSpring, columnWidth, Spring.constant(10));
        layout.putConstraint("West", (Component)downloadLocation, hSpring, "West", (Component)panel);
        layout.putConstraint("West", (Component)this.javaPath, hSpring, "West", (Component)panel);
        layout.putConstraint("West", (Component)this.additionalJavaOptions, hSpring, "West", (Component)panel);
        layout.putConstraint("West", (Component)this.mcWindowSizeWidth, hSpring, "West", (Component)panel);
        layout.putConstraint("West", (Component)this.mcWindowPosX, hSpring, "West", (Component)panel);
        columnWidth = Spring.width(this.mcWindowSizeWidth);
        columnWidth = Spring.max(columnWidth, Spring.width(this.mcWindowPosX));
        hSpring = Spring.sum(hSpring, columnWidth);
        layout.putConstraint("East", (Component)this.mcWindowSizeWidth, hSpring, "West", (Component)panel);
        layout.putConstraint("East", (Component)this.mcWindowPosX, hSpring, "West", (Component)panel);
        hSpring = Spring.sum(hSpring, Spring.constant(5));
        layout.putConstraint("West", (Component)this.mcWindowSizeSepLbl, hSpring, "West", (Component)panel);
        layout.putConstraint("West", (Component)this.mcWindowPosSepLbl, hSpring, "West", (Component)panel);
        columnWidth = Spring.width(this.mcWindowSizeSepLbl);
        columnWidth = Spring.max(columnWidth, Spring.width(this.mcWindowPosSepLbl));
        hSpring = Spring.sum(hSpring, columnWidth);
        hSpring = Spring.sum(hSpring, Spring.constant(5));
        layout.putConstraint("West", (Component)this.mcWindowSizeHeight, hSpring, "West", (Component)panel);
        layout.putConstraint("West", (Component)this.mcWindowPosY, hSpring, "West", (Component)panel);
        columnWidth = Spring.width(this.mcWindowSizeHeight);
        columnWidth = Spring.max(columnWidth, Spring.width(this.mcWindowPosY));
        hSpring = Spring.sum(hSpring, columnWidth);
        layout.putConstraint("East", (Component)downloadLocation, hSpring, "West", (Component)panel);
        layout.putConstraint("East", (Component)this.javaPath, hSpring, "West", (Component)panel);
        layout.putConstraint("East", (Component)this.additionalJavaOptions, hSpring, "West", (Component)panel);
        layout.putConstraint("East", (Component)this.mcWindowSizeHeight, hSpring, "West", (Component)panel);
        layout.putConstraint("East", (Component)this.mcWindowPosY, hSpring, "West", (Component)panel);
        hSpring = Spring.sum(hSpring, Spring.constant(10));
        layout.putConstraint("HorizontalCenter", (Component)this.exit, 0, "HorizontalCenter", (Component)panel);
        layout.putConstraint("East", (Component)panel, hSpring, "West", (Component)panel);
        Spring vSpring = Spring.constant(10);
        layout.putConstraint("Baseline", (Component)this.downloadLocationLbl, 0, "Baseline", (Component)downloadLocation);
        layout.putConstraint("North", (Component)downloadLocation, vSpring, "North", (Component)panel);
        Spring rowHeight = Spring.height(this.downloadLocationLbl);
        rowHeight = Spring.max(rowHeight, Spring.height(downloadLocation));
        vSpring = SwingUtils.springSum(vSpring, rowHeight, Spring.constant(10));
        layout.putConstraint("Baseline", (Component)this.javaPathLbl, 0, "Baseline", (Component)this.javaPath);
        layout.putConstraint("North", (Component)this.javaPath, vSpring, "North", (Component)panel);
        rowHeight = Spring.height(this.javaPathLbl);
        rowHeight = Spring.max(rowHeight, Spring.height(this.javaPath));
        vSpring = SwingUtils.springSum(vSpring, rowHeight, Spring.constant(10));
        layout.putConstraint("Baseline", (Component)this.additionalJavaOptionsLbl, 0, "Baseline", (Component)this.additionalJavaOptions);
        layout.putConstraint("North", (Component)this.additionalJavaOptions, vSpring, "North", (Component)panel);
        rowHeight = Spring.height(this.additionalJavaOptionsLbl);
        rowHeight = Spring.max(rowHeight, Spring.height(this.additionalJavaOptions));
        vSpring = SwingUtils.springSum(vSpring, rowHeight, Spring.constant(10));
        layout.putConstraint("Baseline", (Component)this.mcWindowSizeLbl, 0, "Baseline", (Component)this.mcWindowSizeWidth);
        layout.putConstraint("North", (Component)this.mcWindowSizeWidth, vSpring, "North", (Component)panel);
        layout.putConstraint("Baseline", (Component)this.mcWindowSizeSepLbl, 0, "Baseline", (Component)this.mcWindowSizeWidth);
        layout.putConstraint("North", (Component)this.mcWindowSizeHeight, vSpring, "North", (Component)panel);
        rowHeight = SwingUtils.springMax(Spring.height(this.mcWindowSizeLbl), Spring.height(this.mcWindowSizeWidth), Spring.height(this.mcWindowSizeSepLbl), Spring.height(this.mcWindowSizeHeight));
        vSpring = SwingUtils.springSum(vSpring, rowHeight, Spring.constant(10));
        layout.putConstraint("Baseline", (Component)this.mcWindowPosLbl, 0, "Baseline", (Component)this.mcWindowPosX);
        layout.putConstraint("North", (Component)this.mcWindowPosX, vSpring, "North", (Component)panel);
        layout.putConstraint("Baseline", (Component)this.mcWindowPosSepLbl, 0, "Baseline", (Component)this.mcWindowPosX);
        layout.putConstraint("North", (Component)this.mcWindowPosY, vSpring, "North", (Component)panel);
        rowHeight = SwingUtils.springMax(Spring.height(this.mcWindowPosLbl), Spring.height(this.mcWindowPosX), Spring.height(this.mcWindowPosSepLbl), Spring.height(this.mcWindowPosY));
        vSpring = SwingUtils.springSum(vSpring, rowHeight, Spring.constant(10));
        layout.putConstraint("North", (Component)this.autoMaxCheck, vSpring, "North", (Component)panel);
        vSpring = SwingUtils.springSum(vSpring, Spring.height(this.autoMaxCheck), Spring.constant(10));
        layout.putConstraint("North", (Component)this.snooper, vSpring, "North", (Component)panel);
        vSpring = SwingUtils.springSum(vSpring, Spring.height(this.snooper), Spring.constant(10));
        layout.putConstraint("North", (Component)this.debugLauncherVerbose, vSpring, "North", (Component)panel);
        vSpring = SwingUtils.springSum(vSpring, Spring.height(this.debugLauncherVerbose), Spring.constant(10));
        layout.putConstraint("North", (Component)this.betaChannel, vSpring, "North", (Component)panel);
        vSpring = SwingUtils.springSum(vSpring, Spring.height(this.betaChannel), Spring.constant(10));
        layout.putConstraint("North", (Component)this.exit, vSpring, "North", (Component)panel);
        vSpring = SwingUtils.springSum(vSpring, Spring.height(this.exit), Spring.constant(10));
        layout.putConstraint("South", (Component)panel, vSpring, "North", (Component)panel);
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }
}

